<?php
/*--------------------------------------------------------------------
 ReadServiceInterface.php 2020-2-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitModel\Database\Service;

use Gambio\Shop\Properties\SellingUnitModel\Database\Exceptions\PropertiesCombinationIdDoesNotExistException;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\PropertiesCombinationIdDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\CombinationModelDto;

/**
 * Interface ReadServiceInterface
 * @package Gambio\Shop\Properties\SellingUnitModel\Database\Service
 */
interface ReadServiceInterface
{
    /**
     * @param PropertiesCombinationIdDto $propertiesValuesIdDto
     *
     * @return CombinationModelDto
     * @throws PropertiesCombinationIdDoesNotExistException
     */
    public function combinationModel(PropertiesCombinationIdDto $propertiesValuesIdDto): CombinationModelDto;
}